<?php

namespace App\Livewire\Cashier;

use App\Livewire\Forms\CartForm;
use App\Models\Auths;
use App\Models\Item;
use App\Models\ItemPrice;
use App\Models\Settings;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class AddCheapestItem extends Component
{
    use LivewireAlert;


    public $searchcheapest = '';
    public $selectedProduct;
    public $products = [];
    public $isEnter = false;
    public $selectedCode;
    public $selectedIndex;

    public CartForm $form;

    public function render()
    {
        $results = [];

        if (strlen($this->searchcheapest) >= 1) {
            $results = DB::table('Luv2_item')->where('company_code', auth()->user()->company_code)
                ->where(function ($query) {
                    $query->where('code', 'ILIKE', '%' . $this->searchcheapest . '%')
                        ->orWhere('barcode', 'LIKE', '%' . $this->searchcheapest . '%')
                        ->orWhere('name', 'ILIKE', '%' . $this->searchcheapest . '%');
                })->limit(10)->get();
            $this->products = $results;
        }

        return view('livewire.cashier.add-cheapest-item', [
            'products' => $results,
        ]);
    }

    public function updatedSearchcheapest()
    {
        $this->selectedProduct = null; // Clear the selected product when the searchcheapest field changes
    }

    public function selectProductByName()
    {
        $product = Item::where('barcode', $this->searchcheapest)
            ->where('company_code', auth()->user()->company_code)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();

        if ($product) {
            $this->toProduct($product);
            $this->dispatch('toIsEnter');
        } else {
            $this->noProduct();
        }
    }

    #[On('toIsEnter')]
    public function trueIsEnter()
    {
        $this->isEnter = true;
        $this->dispatch('toSave');
    }

    public function selectProductByClick($itemCode)
    {
        $product = DB::table('Luv2_item')
            ->where('company_code', auth()->user()->company_code)
            ->where('code', $itemCode)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();
        if ($product) {
            $this->toProduct($product);
        } else {
            $this->noProduct();
        }
    }
    public function selectProduct($index)
    {
        $this->selectedIndex = $index;
        $this->selectedCode = $this->products[$index]->code;

        $product = DB::table('Luv2_item')
            ->where('company_code', auth()->user()->company_code)
            ->where('code', $this->selectedCode)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();

        if ($product) {
            $this->selectedProduct = $product;
            $this->toProduct($product);
        }

        // Clear selectedCode and selectedIndex
        $this->selectedCode = null;
        $this->selectedIndex = null;
        $this->isEnter = true;
        $this->dispatch('toSave');
    }

    public function noProduct()
    {
        $productcheck = Item::where('barcode', $this->searchcheapest)
            ->where('company_code', auth()->user()->company_code)
            ->first();
        if ($productcheck) {
            if ($productcheck->active == 'N') {
                $this->alert('warning', 'Item Is Not Active', [
                    'position' => 'top-center',
                    'timer' => 3000,
                    'toast' => true,
                    'text' => 'Please enter active item !',
                    'width' => '800',
                    'timerProgressBar' => true,
                ]);
            } else {
                $this->alert('warning', 'Item Is Non Sales', [
                    'position' => 'top-center',
                    'timer' => 3000,
                    'toast' => true,
                    'text' => 'Please enter sales item !',
                    'width' => '800',
                    'timerProgressBar' => true,
                ]);
            }
        } else {
            $this->alert('warning', 'Item Not Found', [
                'position' => 'top-center',
                'timer' => 3000,
                'toast' => true,
                'text' => 'Please enter valid item barcode !',
                'width' => '800',
                'timerProgressBar' => true,
            ]);
        }
    }

    public function toProduct($product)
    {
        $user = Auth::user();
        $wh = DB::table('Luv2_warehouse')->where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();

        $pricelist = $wh->pricelist_code;

        // if (session('discountmemb') == 1) { //dinonaktifkandulu
        //     // Apply discount for member
        //     $pricelist = $setting->member_pricelist;
        // }
        $this->selectedProduct = $product;
        $itemCode = $product->code;
        $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $itemCode)->where('pricelist_code', $pricelist)->first();

        $this->form->itemname = $product->name . ' ( FREE ITEM )';
        $this->form->itemcode = $product->code;
        $this->form->itemqty = 1;
        $this->form->itemprice = 0;
        $this->form->nprice = $prices->price;
        $this->form->promo = 0;
        $this->form->promotipe = 0;
        $this->form->pack = 0;
        $this->form->discount = $prices->price;
        $this->form->benefit = 'Cheapest';

        $this->searchcheapest = $product->code; // Update the searchcheapest field with the selected product's code
        $this->dispatch('updateTotalAmount')->to(Invoice::class);
    }

    #[On('toSave')]
    public function save()
    {
        // dd($this->form);
        $user = Auth::user();
        $authorization = Auths::where('menu', 'Transaction')
            ->where('modul', 'Sales')->first(); // Fetch the specific authorization

        $hasPermission = $user->authorizations
            ->filter(function ($authorization) {
                return strpos($authorization->auth, 'C') !== false;
            })
            ->contains('id_auth', $authorization->id);
        if ($hasPermission) {
            $cart = $this->form->store();
            $this->reset(['searchcheapest', 'selectedProduct']);
            $this->dispatch('cart-created')->to(Table::class);
            $this->dispatch('updatePrice')->to(Transaction::class);
            $this->form->reset();
        }

        if ($this->isEnter) {
            $this->dispatch('closeModalCheapest');
        }

        $this->isEnter = false;
        session(['Promo-GWP-CheapestItemNONAKTIF' . auth()->user()->id => true]);

        if (session()->has('Promo-GWP-ValueCheapest' . auth()->user()->id)) {
            $session = session('Promo-GWP-ValueCheapest' . auth()->user()->id);
            session(['Promo-GWP-ValueCheapestFulfil' . auth()->user()->id => $session]);
        }
        $this->products = [];
    }
}
