<?php

namespace App\Jobs;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class CreateDataInFirstJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $code;
    protected $validatedData;
    protected $maxId;

    public function __construct($code, $validatedData, $maxId)
    {
        $this->code = $code;
        $this->validatedData = $validatedData;
        $this->maxId = $maxId;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $code = $this->code;
        $validatedData = $this->validatedData;
        $maxId = $this->maxId;

        DB::beginTransaction();

        try {
            $now = Carbon::now();
            $name = $validatedData['name'];
            $abbreviation = strtoupper(implode('', array_map(fn($word) => $word[0], explode(' ', $name))));
            $randomResult = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 2) . rand(10, 99);

            $whcode = substr('WH' . $abbreviation . $randomResult, 0, 12);
            $plcode = substr('PL' . $abbreviation . $randomResult, 0, 12);
            $lastFourDigits = substr($code, -4);
            $tanggal = $now->isoFormat('YYMMDDHHmm');

            DB::table('Luv2_pricelist')->insert([
                'company_code' => $code,
                'code' => $plcode,
                'name' => 'Pricelist Default',
                'created_at' => $now,
                'updated_at' => $now,
            ]);

            DB::table('Luv2_salesemp')->insert([
                'company_code' => $code,
                'code' => 'SLSDFLT',
                'name' => 'John Doe',
                'position' => 'Cashier',
                'remark' => '-',
                'active' => 'Y',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
            

            DB::table('Luv2_warehouse')->insert([
                'company_code' => $code,
                'code' => $whcode,
                'name' => $validatedData['name'],
                'pricelist_code' => $plcode,
                'address' => $validatedData['address'],
                'phone' => $validatedData['phone'],
                'email' => $validatedData['email'],
                'footer' => '-',
                'active' => 'Y',
            ]);

            DB::table('Luv2_brand')->insert([
                'company_code' => $code,
                'code' => 'BRNDFLT',
                'name' => 'Brand Default',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);

            DB::table('Luv2_category')->insert([
                'company_code' => $code,
                'code' => 'CTRDFLT',
                'name' => 'Category Default',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);

            DB::table('Luv2_size')->insert([
                'company_code' => $code,
                'code' => 'SZEDFLT',
                'name' => 'Size Default',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'unique_code' => $lastFourDigits . 'SZEDFLT' . $tanggal,
            ]);

            DB::table('Luv2_supplier')->insert([
                'company_code' => $code,
                'code' => 'SPRDFLT',
                'name' => 'Supplier Default',
                'address' => '-',
                'phone' => 0,
                'email' => '-',
                'consignment' => 'N',
                'shared_margin' => 0,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);

            DB::table('Luv2_item')->insert([
                'company_code' => $code,
                'code' => 'ITMDFLT',
                'barcode' => 'ITMDFLT',
                'name' => 'Item01',
                'brand_code' => 'BRNDFLT',
                'category_code' => 'CTRDFLT',
                'size_code' => 'SZEDFLT',
                'status' => 'Y',
                'inventory' => 'Y',
                'sales' => 'Y',
                'purchase' => 'Y',
                'consignment' => 'N',
                'supp_code' => '',
                'active' => 'Y',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);

            DB::table('Luv2_item_pricelist')->insert([
                'company_code' => $code,
                'item_code' => 'ITMDFLT',
                'pricelist_code' => $plcode,
                'price' => 100000,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);

            $menus = [
                'Home',
                'Cashier',
                'Member',
                'Master',
                'Opname',
                'Goods Receipt',
                'Goods Return',
                'Item Transfer',
                'Dashboard',
                'Warehouse',
                'Supplier',
                'SalesEmployee',
                'Pricelist',
                'Product',
                'Promo',
                'Brand',
                'Greeting',
                'Tutorial',
            ];

            foreach ($menus as $menu) {
                DB::table('Luv2_tutorial')->insert([
                    'id_user' => $maxId + 1,
                    'menu' => $menu,
                    'active' => 'Y',
                ]);
            }

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e; 
        }
    }
}
