<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Mail\SandboxMail;
use App\Models\SandboxItem;
use App\Models\Settings;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class LogoutController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    use AuthenticatesUsers;

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function logout(Request $request)
    {
        
        $user = auth()->user();
        if($user->role == 'Admin'){
            $user->whs_code = '-';  
            $user->save();
        }
        
        $this->guard()->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        if ($response = $this->loggedOut($request)) {
            return $response;
        }

        return $request->wantsJson()
            ? new JsonResponse([], 204)
            : redirect('/');
    }
}
