<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Jobs\CreateDataInFirstJob;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Laravel\Socialite\Facades\Socialite;
use App\Mail\WelcomeGoogleUser;
use Illuminate\Support\Facades\Mail;

class GoogleSocialiteController extends Controller
{
    public function redirectToGoogle()
    {
        return Socialite::driver('google')->redirect();
    }

    public function handleCallback()
    {
        try {
            $user = Socialite::driver('google')->stateless()->user();
            $finduser = DB::table('Luv2_user')->where('email', $user->email)->first();
            if (!$finduser) {
                DB::beginTransaction();

                try {
                    $code = Carbon::now()->format('ymdHis');

                    DB::table('Luv2_company')->insert([
                        'code' => $code,
                        'name' => $user->name,
                        'address' => '-',
                        'phone' => '-',
                        'email' => $user->email,
                        'plan' => 'Pro',
                        'verified_at' => Carbon::now(),
                        'expired_at' => Carbon::now()->addMonth(),
                        'updated_at' => Carbon::now(),
                    ]);

                    $maxId = DB::table('Luv2_user')->max('id');
                    DB::table('Luv2_user')->insert([
                        'id' => $maxId + 1,
                        'company_code' => $code,
                        'whs_code' => '-',
                        'code' => $code,
                        'email' => $user->email,
                        'username' => explode('@', $user->email)[0],
                        'password' => Hash::make('password'),
                        'active' => 'Y',
                        'role' => 'Admin',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                        'social_id' => $user->id,
                        'social_token' => $user->token,
                    ]);

                    DB::commit();
                    Log::channel('login')->info(
                        "\n" .
                            "**Google Auth Callback** \n" .
                            "User ID: {$user->id} \n" .
                            "Name: {$user->name} \n" .
                            "Email: {$user->email} \n" .
                            "Avatar: {$user->avatar} \n" .
                            "Token: {$user->token} \n" .
                            "Raw Data: " . json_encode($user, JSON_PRETTY_PRINT) . "\n" .
                            "Time: " . now()->toDateTimeString() . "\n" .
                            "----------------------------------------------------"
                    );

                    try {
                        Mail::to($user->email)->send(new WelcomeGoogleUser());
                    } catch (\Exception $e) {
                        Log::error('Failed to send welcome email: ' . $e->getMessage());
                    }

                    $userLogin = DB::table('Luv2_user')->where('id', $maxId + 1)->first();

                    $validatedData = [];
                    $validatedData['company_code'] = $code;
                    $validatedData['code'] = $code;
                    $validatedData['company_name'] = $user->name;
                    $validatedData['name'] = $user->name;
                    $validatedData['address'] = '-';
                    $validatedData['phone'] = '-';
                    $validatedData['email'] = $user->email;
                    $validatedData['username'] = explode('@', $user->email)[0];
                    $validatedData['password'] = 'password';
                    $validatedData['plan'] = 'Pro';

                    CreateDataInFirstJob::dispatchSync($userLogin->code, $validatedData, $maxId);


                    //     return response()->make("
                    //     <script>
                    //         window.location.href = 'https://softcomp.io/register?session={$userLogin->social_token}';
                    //     </script>
                    // ");
                    $sessionToken = Str::random(60);

                    DB::table('Luv2_user')
                        ->where('id', $maxId + 1)
                        ->update([
                            'session_token' => $sessionToken,
                            'last_login_at' => Carbon::now(),
                            'login_count' => $userLogin->login_count + 1
                        ]);

                    session(['session_token' => $sessionToken]);

                    Auth::loginUsingId($userLogin->id);



                    return redirect('/verify-warehouse');
                } catch (\Exception $e) {
                    DB::rollBack();
                    Log::error('Google Registration Failed: ' . $e->getMessage());
                    return redirect()->route('login')->with('error', 'Registration failed. Please try again.');
                }
            } else {
                // if (is_null($finduser->social_token)) {
                    $sessionToken = Str::random(60);

                    DB::table('Luv2_user')
                        ->where('id', $finduser->id)
                        ->update([
                            'session_token' => $sessionToken,
                            'last_login_at' => Carbon::now(),
                            'login_count' => $finduser->login_count + 1
                        ]);

                    session(['session_token' => $sessionToken]);

                    Auth::loginUsingId($finduser->id);

                    return redirect('/cashier');
            //     } else {
            //         return response()->make("
            //     <script>
            //         window.location.href = 'https://softcomp.io/register?session={$finduser->social_token}';
            //     </script>
            // ");
            //     }
            }
        } catch (\Exception $e) {
            return redirect()->away('https://softcomp.io');
        }
    }
}
