<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Auth;
use Exception;
use Socialite;

class FacebookSocialiteController extends Controller
{
    public function redirectToFacebook()
    {
        return Socialite::driver('facebook')->redirect();
    }

    public function handleCallback()
    {
        try {
            $user = Socialite::driver('facebook')->user();

            $finduser = User::where('social_id', $user->id)->first();

            if ($finduser)  // if user found then do this
            {
                Auth::login($finduser);

                return redirect('/');
            }
            else
            {
                $newUser = User::create([
                    'name' => $user->name,
                    'email' => $user->email,
                    'social_id' => $user->id,
                    'social_type' => 'Facebook',
                    'password' => bcrypt('password'),  // fill password by whatever pattern you choose
                    'role' => 'Member',
                ]);

                Auth::login($newUser);

                return redirect('/member/register');
            }

        }
        catch (Exception $e)
        {
            dd($e->getMessage());
        }
    }
}
