<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class DeleteExpiredVerified extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'verified:delete-expired';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete companys with expired verified';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $expiredCompanies = DB::table('Luv2_company')
            ->whereNull('verified_at')
            ->where('updated_at', '<', now()->subDay())
            ->get();

            foreach ($expiredCompanies as $company) {
                $companyCode = $company->code;
            
                DB::transaction(function () use ($companyCode) {
                    $userIds = DB::table('Luv2_user')
                        ->where('company_code', $companyCode)
                        ->pluck('id');
            
                    if ($userIds->isNotEmpty()) {
                        DB::table('Luv2_tutorial')->whereIn('id_user', $userIds)->delete();
                    }
            
                    DB::table('Luv2_user')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_pricelist')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_salesemp')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_warehouse')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_brand')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_category')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_size')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_supplier')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_item_pricelist')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_item')->where('company_code', $companyCode)->delete();
                    DB::table('Luv2_company')->where('code', $companyCode)->delete();
                });
            
                $this->info("Deleted company $companyCode and related data including tutorials.");
            }
            

        info("✅ Finished cleaning up expired, unverified companies."); 
    }
}
