/** @type {import('next').NextConfig} */
const nextConfig = {
  eslint: {
    ignoreDuringBuilds: true,
  },
  typescript: {
    ignoreBuildErrors: true,
  },
  images: {
    domains: ['images.pexels.com', 'odyssey.softcomp.io'],
    remotePatterns: [
      {
        protocol: 'https',
        hostname: 'odyssey.softcomp.io',
        port: '',
        pathname: '/storage/**',
      },
      {
        protocol: 'http',
        hostname: 'odyssey.softcomp.io',
        port: '',
        pathname: '/storage/**',
      },
      {
        protocol: 'https',
        hostname: 'odyssey.softcomp.io',
        port: '',
        pathname: '/storage/app/public/assets/package/**',
      },
      {
        protocol: 'http',
        hostname: 'odyssey.softcomp.io',
        port: '',
        pathname: '/storage/app/public/assets/package/**',
      },
      {
        protocol: 'https',
        hostname: '127.0.0.1',
        port: '8082',
        pathname: '/storage/**',
      },
      {
        protocol: 'http',
        hostname: '127.0.0.1',
        port: '8082',
        pathname: '/storage/**',
      },
    ],
    unoptimized: true,
  }
}

export default nextConfig
