import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"

export default function BookingFooter() {
  return (
    <footer className="bg-black text-white mt-4 sm:mt-8">
      <div className="max-w-6xl mx-auto px-4 sm:px-6 py-6 sm:py-8">
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 sm:gap-8">
          {/* Products */}
          <div>
            <h3 className="text-xs sm:text-sm font-bold mb-3 sm:mb-4 text-white">PRODUCTS</h3>
            <ul className="space-y-1 sm:space-y-2 text-xs text-gray-300">
              <li><a href="https://www.odysseysurfschool.com/surfing-lessons/" className="hover:text-white transition-colors">Surfing Lessons</a></li>
              <li><a href="https://www.odysseysurfschool.com/surfing-lessons/surf-packages/" className="hover:text-white transition-colors">Surfing Packages</a></li>
              <li><a href="https://odybooking.softcomp.io/schedule" className="hover:text-white transition-colors">Surfing Schedules</a></li>
              <li><a href="https://www.odysseysurfschool.com/surf-instructors/" className="hover:text-white transition-colors">Surfing Instructors</a></li>
              <li><a href="https://www.odysseysurfschool.com/surfing-lessons/surf-board-rental/" className="hover:text-white transition-colors">Surf Board Rental</a></li>
              <li><a href="https://www.odysseysurfschool.com/lpk-pricing/" className="hover:text-white transition-colors">Rates & Pricing</a></li>
              <li><a href="https://www.odysseysurfschool.com/surf-equipments/" className="hover:text-white transition-colors">Surf Equipments</a></li>
            </ul>
          </div>

          {/* About Us */}
          <div>
            <h3 className="text-xs sm:text-sm font-bold mb-3 sm:mb-4 text-white">ABOUT US</h3>
            <ul className="space-y-1 sm:space-y-2 text-xs text-gray-300">
              <li><a href="https://www.odysseysurfschool.com/faq/" className="hover:text-white transition-colors">FAQ</a></li>
              <li><a href="https://www.odysseysurfschool.com/testimonials/" className="hover:text-white transition-colors">Testimonials</a></li>
              <li><a href="https://www.odysseysurfschool.com/photo-gallery/" className="hover:text-white transition-colors">Photo Gallery</a></li>
              <li><a href="https://www.odysseysurfschool.com/news-events/" className="hover:text-white transition-colors">News & Events</a></li>
              <li><a href="https://www.odysseysurfschool.com/a-board-for-a-smile/" className="hover:text-white transition-colors">A board for a smile</a></li>
              <li><a href="https://www.odysseysurfschool.com/office-location/" className="hover:text-white transition-colors">Our Location</a></li>
              <li><a href="https://www.odysseysurfschool.com/terms-conditions/" className="hover:text-white transition-colors">Terms & Conditions</a></li>
              <li><a href="https://www.odysseysurfschool.com/partners-certification/" className="hover:text-white transition-colors">Partners & Certification</a></li>
              <li><a href="https://www.odysseysurfschool.com/contact-us/" className="hover:text-white transition-colors">Contact Us</a></li>
              <li><a href="https://www.odysseysurfschool.com/partnership/" className="hover:text-white transition-colors">Partnership</a></li>
              <li><a href="https://www.odysseysurfschool.com/hotdeals/" className="hover:text-white transition-colors">Hot Deals</a></li>
            </ul>
          </div>

          {/* Help */}
          <div>
            <h3 className="text-xs sm:text-sm font-bold mb-3 sm:mb-4 text-white">HELP</h3>
            <ul className="space-y-1 sm:space-y-2 text-xs text-gray-300">
              <li><a href="https://www.odysseysurfschool.com/blog/" className="hover:text-white transition-colors">Blog</a></li>
              <li><a href="https://www.odysseysurfschool.com/bali-surfing-information/" className="hover:text-white transition-colors">Bali Surfing Information</a></li>
              <li><a href="https://www.odysseysurfschool.com/surfing-articles/" className="hover:text-white transition-colors">Surfing Articles</a></li>
              <li><a href="https://www.odysseysurfschool.com/sitemap/" className="hover:text-white transition-colors">Sitemap</a></li>
              <li><a href="https://www.odysseysurfschool.com/links/" className="hover:text-white transition-colors">Links</a></li>
            </ul>
          </div>

          {/* Contact Info */}
          <div>
            <div className="text-xs text-gray-300 space-y-1">
              <p>Odysseys Surf School - Mercure Kuta Hotel Arcade</p>
              <p>Jalan Pantai Kuta, Kuta Bali</p>
              <p>📞 Call/ WA/sms +6281766642225</p>
              <p>📧 odysseysurfschool</p>
              <p>🆔 Using ID : Odysseys-Ricmond</p>
              <p>💬 Support with us on Skype</p>
              <p>📠 Fax: (0361) 7631026</p>
              <p>📧 info@odysseysurfschool.com</p>
            </div>
          </div>
        </div>

        {/* Partners Section */}
        <div className="mt-6 sm:mt-8 pt-6 sm:pt-8 border-t border-gray-800">
          {/* <h3 className="text-xs sm:text-sm font-bold mb-3 sm:mb-4 text-gray-400">OUR PARTNERS</h3> */}
          <div className="flex flex-col sm:flex-row items-center justify-between gap-4 sm:gap-8">
            <div className="flex items-center gap-4 sm:gap-8">
              <div className="flex items-center gap-3 sm:gap-4">
                {/* OAKLEY Logo */}
                {/* <div className="w-16 h-8 sm:w-20 sm:h-10 lg:w-24 lg:h-12 bg-white rounded flex items-center justify-center">
                  <svg className="w-12 h-6 sm:w-16 sm:h-8 lg:w-20 lg:h-10" viewBox="0 0 100 40" fill="none">
                    <path d="M10 8h8v24H10V8zm8 8h8v8h-8v-8zm8-8h8v24h-8V8zm8 8h8v8h-8v-8zm8-8h8v24h-8V8zm8 8h8v8h-8v-8zm8-8h8v24h-8V8z" fill="#000"/>
                  </svg>
                </div> */}
                {/* <div className="text-white text-xs sm:text-sm font-bold">OAKLEY</div> */}
              </div>
              <div className="flex gap-2 sm:gap-4">
                {/* <div className="w-8 h-8 sm:w-10 sm:h-10 lg:w-12 lg:h-12 bg-gray-700 rounded-full"></div>
                <div className="w-8 h-8 sm:w-10 sm:h-10 lg:w-12 lg:h-12 bg-gray-700 rounded-full"></div>
                <div className="w-8 h-8 sm:w-10 sm:h-10 lg:w-12 lg:h-12 bg-gray-700 rounded-full"></div> */}
              </div>
            </div>
            {/* Social Media Icons */}
            <div className="flex gap-2 sm:gap-3">
              {/* YouTube */}
              <a href="https://youtube.com/channel/UCmfyjWUSkUhWaXi8gY-PCFA" target="_blank" rel="noopener noreferrer" className="group" title="YouTube">
                <div className="w-6 h-6 sm:w-7 sm:h-7 lg:w-8 lg:h-8 bg-red-500 rounded-lg flex items-center justify-center shadow-md hover:scale-110 transition-transform duration-200">
                  <svg className="w-3 h-3 sm:w-4 sm:h-4 lg:w-5 lg:h-5 text-white" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                  </svg>
                </div>
              </a>

              {/* Twitter */}
              <a href="https://twitter.com/odysseysurfbali" target="_blank" rel="noopener noreferrer" className="group" title="Twitter">
                <div className="w-6 h-6 sm:w-7 sm:h-7 lg:w-8 lg:h-8 bg-blue-400 rounded-lg flex items-center justify-center shadow-md hover:scale-110 transition-transform duration-200">
                  <svg className="w-3 h-3 sm:w-4 sm:h-4 lg:w-5 lg:h-5 text-white" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                  </svg>
                </div>
              </a>

              {/* LinkedIn */}
              {/* <a href="https://linkedin.com" target="_blank" rel="noopener noreferrer" className="group" title="LinkedIn">
                <div className="w-6 h-6 sm:w-7 sm:h-7 lg:w-8 lg:h-8 bg-blue-600 rounded-lg flex items-center justify-center shadow-md hover:scale-110 transition-transform duration-200">
                  <svg className="w-3 h-3 sm:w-4 sm:h-4 lg:w-5 lg:h-5 text-white" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                  </svg>
                </div>
              </a> */}

              {/* Pinterest */}
              <a href="https://pinterest.com/odysseysurfbali" target="_blank" rel="noopener noreferrer" className="group" title="Pinterest">
                <div className="w-6 h-6 sm:w-7 sm:h-7 lg:w-8 lg:h-8 bg-red-600 rounded-lg flex items-center justify-center shadow-md hover:scale-110 transition-transform duration-200">
                  <svg className="w-3 h-3 sm:w-4 sm:h-4 lg:w-5 lg:h-5 text-white" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.174-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.741.099.12.112.225.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.402.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.357-.629-2.746-1.378l-.748 2.853c-.271 1.043-1.002 2.35-1.492 3.146C9.57 23.812 10.763 24.009 12.017 24.009c6.624 0 11.99-5.367 11.99-11.988C24.007 5.367 18.641.001 12.017.001z"/>
                  </svg>
                </div>
              </a>

              {/* Facebook */}
              <a href="https://facebook.com/odysseysurfschool" target="_blank" rel="noopener noreferrer" className="group" title="Facebook">
                <div className="w-6 h-6 sm:w-7 sm:h-7 lg:w-8 lg:h-8 bg-blue-800 rounded-lg flex items-center justify-center shadow-md hover:scale-110 transition-transform duration-200">
                  <svg className="w-3 h-3 sm:w-4 sm:h-4 lg:w-5 lg:h-5 text-white" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                  </svg>
                </div>
              </a>

              {/* RSS */}
              <a href="https://www.odysseysurfschool.com/feed" target="_blank" rel="noopener noreferrer" className="group" title="RSS Feed">
                <div className="w-6 h-6 sm:w-7 sm:h-7 lg:w-8 lg:h-8 bg-orange-500 rounded-lg flex items-center justify-center shadow-md hover:scale-110 transition-transform duration-200">
                  <svg className="w-3 h-3 sm:w-4 sm:h-4 lg:w-5 lg:h-5 text-white" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M6.18 15.64a2.18 2.18 0 0 1 2.18 2.18C8.36 19.84 7.38 21 6.18 21C4.98 21 4 19.84 4 17.82a2.18 2.18 0 0 1 2.18-2.18M6.18 7.64a2.18 2.18 0 0 1 2.18 2.18C8.36 12.84 7.38 14 6.18 14C4.98 14 4 12.84 4 10.82a2.18 2.18 0 0 1 2.18-2.18M6.18 0C8.28 0 10 1.78 10 3.98C10 6.17 8.28 7.95 6.18 7.95C4.08 7.95 2.36 6.17 2.36 3.98C2.36 1.78 4.08 0 6.18 0M13.64 3.98C13.64 2.79 14.5 1.91 15.64 1.91C16.78 1.91 17.64 2.79 17.64 3.98C17.64 5.17 16.78 6.05 15.64 6.05C14.5 6.05 13.64 5.17 13.64 3.98M15.64 8.05C18.78 8.05 21.36 10.63 21.36 13.77C21.36 14.63 21.36 15.77 21.36 15.77H19.09C19.09 15.77 19.09 14.96 19.09 13.77C19.09 11.22 17.19 9.32 14.64 9.32C12.09 9.32 10.19 11.22 10.19 13.77C10.19 14.96 10.19 15.77 10.19 15.77H7.91C7.91 15.77 7.91 14.63 7.91 13.77C7.91 10.63 10.49 8.05 13.64 8.05"/>
                  </svg>
                </div>
              </a>

              {/* Google+ */}
              {/* <a href="https://plus.google.com" target="_blank" rel="noopener noreferrer" className="group" title="Google+">
                <div className="w-6 h-6 sm:w-7 sm:h-7 lg:w-8 lg:h-8 bg-gray-800 rounded-lg flex items-center justify-center shadow-md hover:scale-110 transition-transform duration-200">
                  <svg className="w-3 h-3 sm:w-4 sm:h-4 lg:w-5 lg:h-5 text-white" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 0C5.383 0 0 5.383 0 12s5.383 12 12 12 12-5.383 12-12S18.617 0 12 0zm5.875 18.458c-1.959 1.959-4.583 3.038-7.375 3.038-5.959 0-10.792-4.833-10.792-10.792S4.541 0 10.5 0c2.792 0 5.416 1.079 7.375 3.038L18.458 5.875C16.499 3.916 13.875 2.837 10.5 2.837c-4.583 0-8.333 3.75-8.333 8.333s3.75 8.333 8.333 8.333c2.792 0 5.416-1.079 7.375-3.038l1.583 1.583z"/>
                    <path d="M15.5 7.5h-2.5v2.5h-2.5v2.5h2.5v2.5h2.5v-2.5h2.5v-2.5h-2.5v-2.5z"/>
                  </svg>
                </div>
              </a> */}

              {/* Instagram */}
              <a href="https://instagram.com/odysseysurfschool" target="_blank" rel="noopener noreferrer" className="group" title="Instagram">
                <div className="w-6 h-6 sm:w-7 sm:h-7 lg:w-8 lg:h-8 bg-gradient-to-br from-purple-500 via-pink-500 to-orange-500 rounded-lg flex items-center justify-center shadow-md hover:scale-110 transition-transform duration-200">
                  <svg className="w-3 h-3 sm:w-4 sm:h-4 lg:w-5 lg:h-5 text-white" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                  </svg>
                </div>
              </a>
             </div>
          </div>
        </div>
      </div>
    </footer>
  )
} 