"use client"

import ScheduleCalendar from '@/components/ScheduleCalendar';
import Link from 'next/link';
import { Star } from 'lucide-react';
import { usePathname } from 'next/navigation';

export default function SchedulePage() {
  const pathname = usePathname();
  
  return (
    <div className="min-h-screen bg-gray-50">
      {/* Navigation Header */}
      <nav className="bg-white shadow-sm border-b">
        <div className="container mx-auto px-4">
          <div className="flex items-center justify-between h-16">
            <div className="flex items-center gap-2">
              <div className="w-8 h-8 bg-black rounded-full flex items-center justify-center">
                <Star className="w-4 h-4 text-white fill-white" />
              </div>
              <div className="text-black font-bold text-sm leading-tight">
                <div>ODYSSEYS</div>
                <div>SURF</div>
                <div>SCHOOL</div>
              </div>
            </div>
            
            <div className="flex items-center space-x-1">
              <Link 
                href="/" 
                className={`relative px-6 py-2.5 text-sm font-semibold transition-all duration-200 rounded-full group ${
                  pathname === "/" 
                    ? "text-white bg-gradient-to-r from-blue-600 to-blue-700 shadow-lg shadow-blue-500/25" 
                    : "text-gray-600 hover:text-blue-600 hover:bg-blue-50/80"
                }`}
              >
                <span className="relative z-10 tracking-wide">Booking</span>
                {pathname !== "/" && (
                  <div className="absolute inset-0 bg-gradient-to-r from-blue-500/5 to-blue-600/5 rounded-full opacity-0 group-hover:opacity-100 transition-opacity duration-200"></div>
                )}
              </Link>
              <Link 
                href="/schedule" 
                className={`relative px-6 py-2.5 text-sm font-semibold transition-all duration-200 rounded-full group ${
                  pathname === "/schedule" 
                    ? "text-white bg-gradient-to-r from-blue-600 to-blue-700 shadow-lg shadow-blue-500/25" 
                    : "text-gray-600 hover:text-blue-600 hover:bg-blue-50/80"
                }`}
              >
                <span className="relative z-10 tracking-wide">Schedule</span>
                {pathname !== "/schedule" && (
                  <div className="absolute inset-0 bg-gradient-to-r from-blue-500/5 to-blue-600/5 rounded-full opacity-0 group-hover:opacity-100 transition-opacity duration-200"></div>
                )}
              </Link>
            </div>
          </div>
        </div>
      </nav>

      {/* Header Image */}
      <div 
        className="h-[200px] sm:h-[250px] md:h-[300px] lg:h-[350px] w-full bg-cover bg-center bg-no-repeat"
        style={{
          backgroundImage: "url('https://images.pexels.com/photos/6299936/pexels-photo-6299936.jpeg')"
        }}
      />

      {/* Main Content */}
      <div className="py-8">
        <div className="container mx-auto px-4">
          <div className="mb-8">
            <h1 className="text-3xl font-bold text-gray-900 mb-2">Surf School Schedule</h1>
            <p className="text-gray-600">View available time slots for surf lessons and tours</p>
          </div>
          <ScheduleCalendar />
        </div>
      </div>
    </div>
  );
} 