import { NextRequest, NextResponse } from "next/server";

// Update PayPal payment status endpoint
export async function POST(request: NextRequest) {
  try {
    const body = await request.json();

    console.log("🔄 Update Payment Status Request:");
    console.log("🔄 - Body:", JSON.stringify(body, null, 2));

    const {
      booking_no,
      payment_id,
      status,
      paypal_status,
      amount,
      currency,
      webhook_data,
    } = body;

    if (!booking_no) {
      return NextResponse.json(
        { error: "Booking number is required" },
        { status: 400 }
      );
    }

    // Forward the request to your backend API
    const backendResponse = await fetch(
      `${process.env.NEXT_PUBLIC_API_URL}/paypal/update-payment-status`,
      {
        method: "POST",
        headers: {
          Authorization: `Bearer ${process.env.NEXT_PUBLIC_API_TOKEN}`,
          "Content-Type": "application/json",
        },
        body: JSON.stringify({
          booking_no,
          payment_id,
          status,
          paypal_status,
          amount,
          currency,
          webhook_data,
        }),
      }
    );

    if (!backendResponse.ok) {
      const errorText = await backendResponse.text();
      console.error("❌ Backend API Error:", errorText);
      return NextResponse.json(
        { error: "Failed to update payment status in backend" },
        { status: backendResponse.status }
      );
    }

    const result = await backendResponse.json();
    console.log("✅ Payment status updated successfully:", result);

    return NextResponse.json({
      success: true,
      message: "Payment status updated successfully",
      data: result,
    });
  } catch (error) {
    console.error("❌ Update Payment Status Error:", error);
    return NextResponse.json(
      { error: "Internal server error" },
      { status: 500 }
    );
  }
}
